DECLARE SUB LoadPalette ()
' Joe King's Raycaster Demo
' This raycaster I included in this to show you what you can do.  This has
' ceilings and floors, and a sky.  This loads some
' sprites I made using Pixel Plus 256.  It uses it as the sky.  There are
' 5 parts to the sky.  I can tell which one to put by angle% mod 5.  I didn't
' put much REM statements in here because I wasn't using it for a tutorial.
' There are some more parts to the sky for the Sun and Earth.
' But you can read through this code to get an idea of how some of this works.


' I used cosine as sine 90 because cosine is sine + 90.

' This is a little slow, but it works.


        SCREEN 13       ' set the screen mode

        CLS             ' clear the screen

'======================Load the palette and the sprites=======================

CALL LoadPalette

FileName$ = "JOECAST.PUT"
FileNo = FREEFILE
OPEN FileName$ FOR BINARY AS #FileNo
Ints = (LOF(FileNo) - 7) \ 2
CLOSE #FileNo
REDIM SHARED sprites%(1 TO Ints)
DEF SEG = VARSEG(sprites%(1))
BLOAD FileName$, 0
eps% = 302
DEF SEG

'=============================================================================
  
   ' set the variables

        DIM Grid%(10, 10)
       
        DIM SinTable&(449)

        DIM viewfix!(-26 TO 26)

'==================Get the map data and put it into the grid==================
  
  
   ' read the data and put it into the grid
   ' do a for...next loop scanning 10 across and 10 down and put it into
   ' the grid

        FOR yy% = 1 TO 10
        FOR ZZ% = 1 TO 10
       
        READ Grid%(ZZ%, yy%)
       
   ' the the spot on the grid = -1 then set the player's coordinates to it   
   ' and make it 0

        IF Grid%(ZZ%, yy%) = -1 THEN
        Grid%(ZZ%, yy%) = 0
       
        PlayerX& = ZZ%
       
        PlayerY& = yy%

        END IF

   ' continue for...next loop   
       
        NEXT ZZ%
        NEXT yy%


'==============Construct the sin table for using xstep and ystep==============
  
  
   ' construct the sin table by doing a for...next loop

        FOR ZZ% = 0 TO 449

        SinTable&(ZZ%) = (COS(ZZ% * (22 / 7) / 180) * 1024) \ 10

        NEXT ZZ%

FOR i% = -26 TO 26
      viewfix!(i%) = 1 / COS((i% / 360) * 1.8 * (22 / 7))
NEXT i%

'===========================Set the variables=================================
  
  
   ' times the player's coordinates by 1024 to use fixed point math
   ' also get the old player's coordinates to send them back to where they
   ' were if they hit a wall

        PlayerX& = PlayerX& * 1024
        PlayerY& = PlayerY& * 1024

        OldPlayerX& = PlayerX&
        OldPlayerY& = PlayerY&

'===========Start the program===================


        
        DO
        GOSUB raycast
       
        DO
        A$ = INKEY$
        LOOP UNTIL A$ <> ""

        IF A$ = CHR$(0) + "H" THEN PlayerX& = PlayerX& - (SinTable&(an% + 90) * 5): PlayerY& = PlayerY& - (SinTable&(an%) * 5)

        IF A$ = CHR$(0) + "P" THEN PlayerX& = PlayerX& + (SinTable&(an% + 90) * 5): PlayerY& = PlayerY& + (SinTable&(an%) * 5)

        IF A$ = CHR$(0) + "K" THEN an% = an% - 2

        IF A$ = CHR$(0) + "M" THEN an% = an% + 2

        IF A$ = CHR$(27) THEN END

        IF an% < 0 THEN an% = an% + 360
        IF an% > 359 THEN an% = an% - 360
       
   ' if player's coordinates are on on wall then send them equal to their 
   ' old position with a sound
       
        IF Grid%(PlayerX& \ 1024, PlayerY& \ 1024) <> 9 AND Grid%(PlayerX& \ 1024, PlayerY& \ 1024) THEN

        PlayerX& = OldPlayerX&
        PlayerY& = OldPlayerY&

        SOUND 80, 1
       
        END IF


   ' get the oldplayer's coordinates

        OldPlayerX& = PlayerX&
        OldPlayerY& = PlayerY&
       
        LOOP



'==========================The raycasting routine=============================



raycast:

        LinePosition% = 0
        DH% = 64
        fd% = -26

        FOR ZZ% = an% - 26 TO an% + 26
       
        Angle% = ZZ%
       
        IF Angle% < 0 THEN Angle% = Angle% + 360
       
        IF Angle% > 359 THEN Angle% = Angle% - 360
                         
        StepX& = SinTable&(Angle% + 90)
       
        StepY& = SinTable&(Angle%)
       
        xx& = PlayerX&
       
        yy& = PlayerY&
       
        DistanceCount% = 0

   ' send out ray until it hits a wall 
       
        DO
       
        xx& = xx& - StepX&
       
        yy& = yy& - StepY&
       
        DistanceCount% = DistanceCount% + 1
       
        m% = Grid%(xx& \ 1024, yy& \ 1024)
       
        IF m% = 9 OR m% = 7 THEN m% = 0

        LOOP UNTIL m%

        sx& = xx&: sy& = yy&

   ' calculate the actual distance and then draw a piece of the wall

        Distance! = (900 / DistanceCount%)

        Distance! = Distance! * viewfix!(fd%)

        sprites%((eps% * ((Angle% MOD 5) + 28)) + 2) = 100 - Distance!
        sp% = sprites%((eps% * ((Angle% MOD 5) + 28)) + 2)
       
        IF sp% > 0 THEN PUT (LinePosition%, 0), sprites%((eps% * ((Angle% MOD 5) + 28)) + 1), PSET

        sprites%((eps% * ((Angle% MOD 5) + 28)) + 2) = 100

        IF Angle% > 0 AND Angle% < 8 THEN PUT (LinePosition%, 0), sprites%((eps% * (Angle% + 20)) + 1), AND: PUT (LinePosition%, 0), sprites%((eps% * (Angle% + 13)) + 1), XOR
        IF Angle% > 90 AND Angle% < 98 THEN PUT (LinePosition%, 0), sprites%((eps% * (Angle% - 84)) + 1), AND: PUT (LinePosition%, 0), sprites%((eps% * (Angle% - 91)) + 1), XOR

        LINE (LinePosition%, 199)-(LinePosition% + 5, 100 + Distance! + 1), 185, BF      ' draw from floor up to the bottom of the wall
       
        LINE (LinePosition%, 100 - Distance!)-(LinePosition% + 5, 100 + Distance!), m%, BF      ' draw the wall strip
       
        xx& = PlayerX&
     
        yy& = PlayerY&
       
        DistanceCount% = 0
       
'====Send out another ray to scan for the floor and ceilings======

        DO
       
        xx& = xx& - StepX&
      
        yy& = yy& - StepY&
      
        DistanceCount% = DistanceCount% + 1
      
        m% = Grid%(xx& \ 1024, yy& \ 1024)
      
        IF m% = 9 THEN
        Distance! = (900 / DistanceCount%)
        Distance! = Distance! * viewfix!(fd%)
        LINE (LinePosition%, 100 + Distance!)-(LinePosition% + 5, 100 + (Distance! * 1.1)), 195, BF
        LINE (LinePosition%, 100 - Distance!)-(LinePosition% + 5, 100 - (Distance! * 1.1)), 7, BF
        END IF
        IF m% = 7 THEN
        Distance! = (900 / DistanceCount%)
        Distance! = Distance! * viewfix!(fd%)
        LINE (LinePosition%, 100 + Distance!)-(LinePosition% + 5, 100 + (Distance! * 1.1)), 9, BF
        END IF

        LOOP UNTIL xx& = sx& AND yy& = sy&

        LinePosition% = LinePosition% + 6

        DH% = DH% - 1
       
        fd% = fd% + 1
       
        NEXT ZZ%

        RETURN


'==============================the map data===================================

DATA 5,1,5,1,5,1,5,1,5,1
DATA 1,0,0,0,0,7,0,9,9,1
DATA 1,0,4,2,0,0,0,3,9,1
DATA 1,0,2,4,9,9,0,3,0,1
DATA 1,0,0,9,0,9,6,8,9,1
DATA 1,7,0,9,9,9,8,6,9,1
DATA 1,7,0,0,0,0,0,5,9,1
DATA 1,9,9,0,0,0,7,5,9,1
DATA 1,9,9,0,-1,0,0,0,0,1
DATA 1,1,1,1,1,1,1,1,1,1

SUB LoadPalette

'==========================Load the palette===================================

DEFINT A-Z
REDIM PaletteArray&(0 TO 255)
FileNo = FREEFILE

OPEN "GLOBE1.PAL" FOR BINARY AS #FileNo
FOR n = 0 TO 255
GET #FileNo, , colour&
PaletteArray&(n) = colour&
NEXT n
CLOSE #FileNo
DIM RGBval(0 TO 255, 0 TO 2)
FOR n = 0 TO 255
c& = PaletteArray&(n)
b = c& \ 65536: c& = c& - b * 65536
g = c& \ 256: c& = c& - g * 256
r = c&
RGBval(n, 0) = r
RGBval(n, 1) = g
RGBval(n, 2) = b
NEXT n
WAIT &H3DA, &H8, &H8: WAIT &H3DA, &H8
FOR n = 0 TO 255
OUT &H3C8, n
OUT &H3C9, RGBval(n, 0)
OUT &H3C9, RGBval(n, 1)
OUT &H3C9, RGBval(n, 2)
NEXT n

END SUB

